/*

  Mimics the fade example but with an extra parameter for frequency. It should dim but with a flicker
  because the frequency has been set low enough for the human eye to detect. This flicker is easiest to see when
  the LED is moving with respect to the eye and when it is between about 20% - 60% brighness. The library
  allows for a frequency range from 1Hz - 2MHz on 16 bit timers and 31Hz - 2 MHz on 8 bit timers. When
  SetPinFrequency()/SetPinFrequencySafe() is called, a bool is returned which can be tested to verify the
  frequency was actually changed.

  This example runs on mega and uno.
*/
//#include <MsTimer2.h> // inclusion de la librairie Timer2
//#include <TimerOne.h>
#include <LiquidCrystal_74HC595.h>
#include <SimpleModbusSlave.h>
#include <PWM.h>
#include <SM.h>

SM OnePULSE(&etape1);
SM Display(&etape100);//display position and speed

#define DS 11
#define SHCP 13
#define STCP 12
#define RS 1
#define E 3 //2
#define D4 4 //3
#define D5 5 //4
#define D6 6 // 5
#define D7 7 //6

LiquidCrystal_74HC595 lcd(DS, SHCP, STCP, RS, E, D4, D5, D6, D7);







#define FASTADC 1
// defines for setting and clearing register bits
#ifndef cbi
#define cbi(sfr, bit) (_SFR_BYTE(sfr) &= ~_BV(bit))
#endif
#ifndef sbi
#define sbi(sfr, bit) (_SFR_BYTE(sfr) |= _BV(bit))
#endif

//use pin 11 on the Mega instead, otherwise there is a frequency cap at 31 Hz
int led = 9;                // the pin that the LED is attached to
int brightness = 0;         // how bright the LED is
int fadeAmount = 5;         // how many points to fade the LED by
int32_t frequency = 250000; //frequency (in Hz)
unsigned long count;
unsigned long pd;       // Pulse Delay period
int spd = A0;     // Potentiometer
int READ;
unsigned long currentTime = 0;
unsigned long previousTime = 0;
unsigned long interval;
//volatile int master_count = 0; // universal count
volatile int master_count = 0; // universal count
unsigned long step_count = 0; // universal count
volatile byte CHApulseCount = 0; // interrupt status flag
volatile byte RPM = 0;
boolean setdir = HIGH; // Set Direction

void setup()
{

  Serial.begin(9600);
  lcd.begin(20, 4);              // initialize the lcd
  lcd.setCursor ( 0, 0 );        // go to the next line
  lcd.print ("HYBRIDE STEP MOTOR");
  //Change acquisition time for ADC

#if FASTADC// ex: 16Mhz/128= 125KHZ, 13 adc clocks needed, adc Prescale settings
  //125/13=9600Hz à la base soit 105 µs
  //pour 16: 16000000/(16*13)=76923hz 13µS
  //pour 32: 16000000/(32*13)=38461hz 26µs
  //pour 64: 16000000/(64*13)=19230hz 52µs
  //pour 128 104µs
  //sbi pour 1
  //cbi pour 0
  // set prescale to     16   8    4   2    128    64    32
  cbi(ADCSRA, ADPS2) ; // 1    0    0   0     1      1    1
  sbi(ADCSRA, ADPS1) ; // 0    1    1   0     1      1    0
  cbi(ADCSRA, ADPS0) ; // 0    1    0   1     1      0    1
#endif//here I use a prescale of 16




  //initialize all timers except for 0, to save time keeping functions
  InitTimersSafe();

  //sets the frequency for the specified pin
  //bool success = SetPinFrequencySafe(led, frequency);

  //if the pin frequency was set successfully, turn pin 13 on
  //if(success) {
  pinMode(3, INPUT);
  //pinMode(13, OUTPUT);
  digitalWrite(13, LOW);
  //}

  attachInterrupt(1, flag, FALLING);//
  attachInterrupt(1, STEPcount, FALLING);//
  //MsTimer2::set(500, POTAR); // période 1000ms
  //MsTimer2::start(); // active Timer 2



}

void loop()
{
  EXEC(OnePULSE);//run statemachine
  EXEC(Display);
  //use this functions instead of analogWrite on 'initialized' pins




  pwmWrite(led, 127);
  //if (count>=750000) digitalWrite(13, HIGH);




  //analogWrite(led,0);
  brightness = brightness + fadeAmount;

  if (brightness == 0 || brightness == 255) {
    fadeAmount = -fadeAmount ;
  }

}

State etape1() {
  currentTime = micros();



  if ((currentTime - previousTime) > 100000) {
    previousTime = currentTime;
    READ = (analogRead(spd));
    pd = map(READ, 0, 1023, 5000, 25000);
    SetPinFrequencySafe(led, pd);

    currentTime = micros();
  }
  //if ((currentTime - previousTime) > 50000) {
  // previousTime = currentTime;
  //READ = (analogRead(spd));
  //pd = map(READ, 0, 1023, 5000, 25000);
  //SetPinFrequencySafe(led, pd);
  //pwmWrite(led, 127);
  //}

  //if (OnePULSE.Timeout(100)) OnePULSE.Set(etape1);
}
State etape100() {
  CHAcountDisp();
}

void flag() {
  // add 1 to count for CW
  if (setdir == LOW) {
    master_count-- ;
  }
  // subtract 1 from count for CCW
  if (setdir == HIGH) {
    master_count++ ;
  }
  if (master_count < 0) master_count = 0;

}

void STEPcount() {
  step_count++;
}

void POTAR() {

  READ = (analogRead(spd));
  pd = map(READ, 0, 1023, 5000, 25000);
  SetPinFrequencySafe(led, pd);
}
void CHAcountDisp() {
  lcd.setCursor ( 0, 1 );        // go to the next line
  lcd.print ("PULSE Nbr:");

  if (master_count < 10) {
    lcd.setCursor ( 13, 1 );        // go to the next line
    lcd.print ("   ");
    lcd.setCursor ( 16, 1 );        // go to the next line
    lcd.print (master_count);
    lcd.setCursor ( 17, 1 );        // go to the next line
    lcd.print ("   ");
  }
  if ((master_count > 9) && (master_count < 100)) {
    lcd.setCursor ( 13, 1 );        // go to the next line
    lcd.print ("  ");
    lcd.setCursor ( 15, 1 );        // go to the next line
    lcd.print (master_count);
  }
  if ((master_count > 99) && (master_count < 1000)) {
    lcd.setCursor ( 13, 1 );        // go to the next line
    lcd.print (" ");
    lcd.setCursor ( 14, 1 );        // go to the next line
    lcd.print (master_count);
  }
  if (master_count > 999) {
    lcd.setCursor ( 13, 1 );        // go to the next line
    lcd.print (master_count);
  }

}
